const express = require('express');
const SalaryController = require('../controllers/salary')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, SalaryController.postcreate);
router.get('/', tokenMiddleware, SalaryController.getall);
router
    .route('/:id')
    .get(tokenMiddleware, SalaryController.getid)
    .put(tokenMiddleware, SalaryController.putid)
    .delete(tokenMiddleware, SalaryController.delid);
module.exports = router;