const express = require('express');
const ProjectController = require('../controllers/project')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, ProjectController.postcreate);
router.get('/', tokenMiddleware, ProjectController.getall);
router
    .route('/:id')
    .get(tokenMiddleware, ProjectController.getid)
    .put(tokenMiddleware, ProjectController.putid)
    .delete(tokenMiddleware, ProjectController.delid);
module.exports = router;