const express = require('express');
const PrepinjamController = require('../controllers/prepinjam')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, PrepinjamController.postcreate);
router.get('/', tokenMiddleware, PrepinjamController.getall);
router.get('/salary', tokenMiddleware, PrepinjamController.getsalary);

router
    .route('/:id')
    .get(tokenMiddleware, PrepinjamController.getid)
    .put(tokenMiddleware, PrepinjamController.putid)
    .delete(tokenMiddleware, PrepinjamController.delid);
module.exports = router;