const express = require('express');
const BankController = require('../controllers/bank')
const router = express.Router();
const tokenMiddleware = require('../middlewares/verifytoken');

router.post('/', tokenMiddleware, BankController.postcreate);
router.post('/test/', BankController.testaja);
router.get('/', tokenMiddleware, BankController.getall);
router
    .route('/:id')
    .get(tokenMiddleware, BankController.getid)
    .put(tokenMiddleware, BankController.putid)
    .delete(tokenMiddleware, BankController.delid);
module.exports = router;