module.exports = function(sequelize, DataTypes) {
    const Server = sequelize.define("Server", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      hostname: {
        type: DataTypes.STRING(50),
        allowNull: false,
        validate: {
            notNull: {
              msg: "Tidak Boleh Null/Kosong"
          },
          notEmpty: {
              msg: "Tidak Boleh Null/Kosong"
          }
          }
      },
      manage: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        validate: {
            notNull: {
              msg: "Tidak Boleh Null/Kosong. Boolean"
          },
          notEmpty: {
              msg: "Tidak Boleh Null/Kosong. Boolean"
          }
          }
      },
      typeserv: {
        type: DataTypes.STRING(15),
        allowNull: false,
        validate: {
            notNull: {
              msg: "Hanya bisa diisi dengan Colocation atau Dedicated"
          },
          isIn: {
              args: [['Colocation', 'Dedicated']],
              msg: "Hanya bisa diisi dengan Colocation atau Dedicated"
            }
          }
      },
      hargaserv: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        validate: {
            notNull: {
              msg: "Tidak Boleh Null/Kosong"
          },
          notEmpty: {
              msg: "Tidak Boleh Null/Kosong"
          },
          isDecimal: {
              msg: "Format Double, gunakan tanda titik untuk desimal"
          }
          }
      },
      statusaktif: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        validate: {
            notNull: {
              msg: "Tidak Boleh Null/Kosong. Boolean"
          },
          notEmpty: {
              msg: "Tidak Boleh Null/Kosong. Boolean"
          }
          }
      },
      expdate: {
        type: DataTypes.DATEONLY,
        allowNull: false,
        validate: {
            isDate: {
              msg: "Gunakan format tanggal YYYY-MM-DD"
          },
          notNull: {
              msg: "Gunakan format tanggal YYYY-MM-DD"
          }
          }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_server',
      timestamps: true,
    });
    return Server;
  };
  