module.exports = function(sequelize, DataTypes) {
    const Project = sequelize.define("Project", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nmproject: {
        type: DataTypes.STRING(100),
        allowNull: false,
        defaultValue: "-"
      },
      pbproject: {
        type: DataTypes.STRING(100),
        allowNull: false,
        defaultValue: "-"
      },
      nilaiproject: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      tglmulai: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      tglselesai: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      statuspro: {
        type: DataTypes.STRING(20),
        allowNull: false,
        defaultValue: "-"
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_project',
      timestamps: true,
    });
    return Project;
  };
  