module.exports = function(sequelize, DataTypes) {
    const Product = sequelize.define("Product", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nmproduk: {
        type: DataTypes.STRING(100),
        allowNull: false
      },
      typeproduk: {
        type: DataTypes.STRING(50),
        allowNull: false
      },
      groupproduk: {
        type: DataTypes.STRING(50),
        allowNull: false
      },
      whmcs_pid: {
        type: DataTypes.INTEGER,
        allowNull: true,
        defaultValue: 0
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_product',
      timestamps: true,
    });
    return Product;
  };
  