module.exports = function(sequelize, DataTypes) {
    const Pinjam = sequelize.define("Pinjam", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      tglpinjam: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      nip: {
        type: DataTypes.STRING(10),
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
          notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      kredit: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      debet: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      ketpinjam: {
        type: DataTypes.STRING(200),
        allowNull: false,
        defaultValue: "-"
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'tr_pinjam',
      timestamps: true,
    });
    
    return Pinjam;
  };
  