module.exports = function (sequelize, DataTypes) {
    const Karyawan = sequelize.define("Karyawan", {
        nip: {
            type: DataTypes.STRING(50),
            allowNull: false,
            primaryKey: true
        },
        nmlengkap: {
            type: DataTypes.STRING(100),
            allowNull: false,
            validate: {
                notNull: {
                    msg: "Tidak Boleh Null/Kosong"
                },
                notEmpty: {
                    msg: "Tidak Boleh Null/Kosong"
                }
            }
        },
        jabatan: {
            type: DataTypes.STRING(50),
            allowNull: false
        },
        user_id: {
            type: DataTypes.INTEGER,
            allowNull: true,
            validate : {
                isNumeric: {
                    msg: "Harus berupa angka, beri nilai null jika tidak diisi"
                }
            }
        },
        nik: {
            type: DataTypes.STRING(30),
            allowNull: true,
            defaultValue: "-"
        },
        tmptlahir: {
            type: DataTypes.STRING(20),
            allowNull: true,
            defaultValue: "-"
        },
        tgllahir: {
            type: DataTypes.DATEONLY,
            allowNull: true,
            defaultValue: "2001-01-01"
        },
        agama: {
            type: DataTypes.STRING(10),
            allowNull: true,
            defaultValue: "-"
        },
        nohp: {
            type: DataTypes.STRING(15),
            allowNull: true,
            defaultValue: "-"
        },
        pendakhir: {
            type: DataTypes.STRING(50),
            allowNull: true,
            defaultValue: "-"
        },
        ecnama: {
            type: DataTypes.STRING(100),
            allowNull: true,
            defaultValue: "-"
        },
        echp: {
            type: DataTypes.STRING(15),
            allowNull: true,
            defaultValue: "-"
        },
        echub: {
            type: DataTypes.STRING(10),
            allowNull: true,
            defaultValue: "-"
        },
        statusnikah: {
            type: DataTypes.STRING(12),
            allowNull: false,
            defaultValue: "Tidak Kawin"
        },
        jmlanak: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 0
        },
        statusaktif: {
            type: DataTypes.INTEGER,
            allowNull: false,
            defaultValue: 1
        },
        tglmasuk: {
            type: DataTypes.DATEONLY,
            allowNull: true,
            defaultValue: "2001-01-01"
        },
        tglkeluar: {
            type: DataTypes.DATEONLY,
            allowNull: true,
            defaultValue: "2001-01-01"
        },
        createdBy: {
            type: DataTypes.STRING(255),
            allowNull: true
        },
        createdAt: {
            allowNull: false,
            type: DataTypes.DATE
        },
        updatedBy: {
            type: DataTypes.STRING(255),
            allowNull: true
        },
        updatedAt: {
            allowNull: false,
            type: DataTypes.DATE
        }
    }, {
        tableName: 'm_karyawan',
        timestamps: true,
    });
    return Karyawan;
};