module.exports = function(sequelize, DataTypes) {
    const Jenislembur = sequelize.define("Jenislembur", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nmlembur: {
        type: DataTypes.STRING(100),
        allowNull: false,
        unique: true,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
        notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        }
        }
      },
      nilailembur: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        validate: {
          notNull: {
            msg: "Tidak Boleh Null/Kosong"
        },
        notEmpty: {
            msg: "Tidak Boleh Null/Kosong"
        },
        isDecimal: {
            msg: "Format Double, gunakan tanda titik untuk desimal"
        }
        }
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'm_jenislembur',
      timestamps: true,
    });
    return Jenislembur;
  };
  