module.exports = function(sequelize, DataTypes) {
  const Bank = sequelize.define("Bank", {
    id: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    nm_bank: {
      type: DataTypes.STRING(20),
      allowNull: false,
      validate: {
        notNull: {
          msg: "Tidak Boleh Null/Kosong"
      },
      notEmpty: {
          msg: "Tidak Boleh Null/Kosong"
      }
      }
    },
    createdBy: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    createdAt: {
      allowNull: false,
      type: DataTypes.DATE
    },
    updatedBy: {
      type: DataTypes.STRING(255),
      allowNull: true
    },
    updatedAt: {
      allowNull: false,
      type: DataTypes.DATE
    }
  }, 
  {
    tableName: 'm_bank',
    timestamps: true,
  });
  return Bank;
};
