module.exports = function(sequelize, DataTypes) {
    const Ajudana = sequelize.define("Ajudana", {
      id: {
        autoIncrement: true,
        type: DataTypes.INTEGER,
        allowNull: false,
        primaryKey: true
      },
      nip: {
        type: DataTypes.STRING(10),
        allowNull: false
      },
      tgldana: {
        type: DataTypes.DATEONLY,
        allowNull: false
      },
      nmdana: {
        type: DataTypes.STRING(20),
        allowNull: false
      },
      dtproject: {
        type: DataTypes.STRING(60),
        allowNull: false,
        defaultValue: "-"
      },
      jmldana: {
        type: DataTypes.DOUBLE,
        allowNull: false,
        defaultValue: 0
      },
      ketdana: {
        type: DataTypes.STRING(200),
        allowNull: false,
        defaultValue: "-"
      },
      status: {
        type: DataTypes.STRING(15),
        allowNull: false,
        defaultValue: "PENDING"
      },
      note: {
        type: DataTypes.STRING(200),
        allowNull: false,
        defaultValue: "-"
      },
      sproses: {
        type: DataTypes.STRING(15),
        allowNull: false,
        defaultValue: "PENDING"
      },
      createdBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      createdAt: {
        allowNull: false,
        type: DataTypes.DATE
      },
      updatedBy: {
        type: DataTypes.STRING(255),
        allowNull: true
      },
      updatedAt: {
        allowNull: false,
        type: DataTypes.DATE
      }
    }, 
    {
      tableName: 'd_ajudana',
      timestamps: true,
    });
    return Ajudana;
  };
  