const axios = require('axios');
const { whmcsApi }= require('../config/custom.js');

// Fungsi untuk memanggil WHMCS API
async function callWhmcsApi(command, params = {}) {
    const data = {
        action: command,
        identifier: whmcsApi.apiIdentifier,
        secret: whmcsApi.apiSecret,
        responsetype: 'json',
        ...params
    };
    
    try {
        const response = await axios.post(whmcsApi.serverUrl, null, {
            params: data
        });
        //console.log('API Response:', response.data);
        return response.data;

    } catch (error) {
        console.error('Error calling WHMCS API:', error);
        throw error;
    }
}

module.exports = {
    callWhmcsApi
};