const {
    Trlembur,
    Karyawan,
    Jenislembur,
    Sequelize
} = require("../models");
const Op = Sequelize.Op;
const moment = require("moment");
const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;


    //Validasi nama lembur dan NIP

    if (!body.nmlembur | !body.nip) {
        return res.status(400).json({
            "Validation Error": {
                field: "nmlembur/nip",
                message: "Tidak Boleh Null/Kosong"
            }
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }


    try {
        const cekjenislembur = await Jenislembur.findOne({
            where: {
                nmlembur: body.nmlembur,
            },
        });

        if (!cekjenislembur) {
            return res.status(400).json({
                message: "Nama Lembur tidak ditemukan",
            });
        } else {
            try {
                const [nselisih, nhasil, nmark] = await Getnilai(body.jamawal, body.jamakhir, body.nmlembur, cekjenislembur.nilailembur, body.tempat, body.tgllem);
                await Trlembur.create({
                    nip: body.nip,
                    nmlembur: body.nmlembur,
                    tgllem: body.tgllem,
                    jamawal: body.jamawal,
                    jamakhir: body.jamakhir,
                    totaljam: nselisih.toFixed(2),
                    nilailem: nhasil,
                    tempat: body.tempat,
                    ketlembur: body.ketlembur,
                    status: "PENDING",
                    markbulan: nmark,
                    createdBy: createdBy
                });

                return res.status(201).json({
                    message: 'Created'
                });
            } catch (error) {
                if (error.name === 'SequelizeValidationError') {
                    const validationErrors = error.errors.map(err => ({
                        field: err.path,
                        message: err.message
                    }));
                    res.status(400).json({
                        "Validation Error": validationErrors
                    });
                } else {
                    res.status(500).json({
                        error: 'Internal Server Error',
                        message: error.message
                    });
                }
            }
        }

    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error',
            message: error.message
        });
    }

}
async function Getnilai(Jamawal, Jamakhir, Nmlembur, Nlembur, Ntempat, Ntgl) {
    let wawal = Jamawal.split(':')
    let wakhir = Jamakhir.split(':')
    let tj1 = parseInt(wawal[0])
    let tm1 = parseInt(wawal[1])
    let tj2 = parseInt(wakhir[0])
    let tm2 = parseInt(wakhir[1])
    let jamawal = (tj1 * 60) + tm1
    let jamakhir = (tj2 * 60) + tm2
    let nilai = jamakhir - jamawal
    let selisih = 0
    if (tj1 > tj2) {
        selisih = (24 + (nilai / 60))
    } else {
        selisih = nilai / 60
    }
    let hasil = selisih * Nlembur
    if (Nmlembur == "SPK DC") {
        hasil = Nlembur; // Untuk SPK DC. Jumlah Jam tidak pengaruh. 1 SPK DC 1x nilai lembur (50.000)
    }
    if (Ntempat == 'Rumah') {
        let pot = (30 / 100) * hasil;
        hasil = hasil - pot;
    }

    // Get Mark Bulan
    let nilaitgl = moment(Ntgl).format("DD")
    console.log("oritgl :", Ntgl)
    console.log("tgl :", nilaitgl)
    let markbln = (nilaitgl > 25) ? moment().add(1, "month").startOf("month").format('YYYYMM') : moment(Ntgl).format("yyyyMM")

    return [selisih, hasil, markbln]
}
const getall = async (req, res) => {
    const {
        body
    } = req;
    let nnip = '%%'
    let nstatus = '%%'

    if (body.nip) {
        nnip = body.nip
    }
    if (body.status) {
        nstatus = body.status
    }
    if (!body.tahunbln) {
        return res.status(400).json({
            message: "Tentukan tahun dan bulan lembur dengan format YYYYMM",
        });
    } else {
        try {
            const Trlemburs = await Trlembur.findAll({
                attributes: {
                    exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
                },
                where: {
                    markbulan: body.tahunbln,
                    nip: {
                        [Op.like]: nnip,
                    },
                    status: {
                        [Op.like]: nstatus,
                    },
                }
            });
            if (Trlemburs.length != 0) {
                return res.json(Trlemburs);
            } else {
                return res.status(404).json({
                    message: "Data tidak ditemukan"
                });
            }
        } catch (error) {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }


}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Trlemburs = await Trlembur.findByPk(id, {
            attributes: {
                exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt']
            }
        });
        if (!Trlemburs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(Trlemburs);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = {
        ...req.body,
        updatedBy
    };
    try {
        const Trlemburs = await Trlembur.findByPk(id, {});
        if (!Trlemburs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Trlemburs.update(updateData);
        return res.status(201).json({
            message: 'Updated'
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Trlemburs = await Trlembur.findByPk(id, {});
        if (!Trlemburs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Trlemburs.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}