const { Salary } = require("../models");
const {
    Karyawan
} = require("../models");

const postcreate = async (req, res) => {
    const { body } = req;
    const updatedBy = req.user.data.username;
    const createdBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    let createData = { ...req.body, createdBy };

    if (!body.blnsal | !body.nip){
        return res.status(400).json({
            "Validation Error": {
                field:"blnsal/nip",
                message:"Tidak Boleh Null/Kosong"}
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }

    const cekBulansal = await Salary.findOne({
        where: {
            blnsal: body.blnsal,
            nip: body.nip
        },
    });

    if (cekBulansal) {
        try {
            await cekBulansal.update(updateData);
            return res.status(201).json({
                message: 'Updated'            
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }
        
    }else{
        
        try {
            await Salary.create(createData);
    
            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }
    }    
}
const getall = async (req, res) => {
    const {
        body
    } = req;
    if (!body.blnsal){
        return res.status(400).json({
            message: "Tentukan tahun dan bulan salary",
        });
    }else{
        try {
            const thsalary = await Salary.findAll({
                attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] },
                where: {
                    blnsal: body.blnsal
                }
            });
            if (thsalary.length != 0) {
                return res.json(thsalary);
            } else {
                res.status(404).json({
                    message: "Data tidak ditemukan",
                })            
            }
    
        } catch (error) {
            res.status(500).json({error: 'Internal Server Error'})
        }
    } 
    
}
const getid = async (req, res) => {
    const { id } = req.params;

    try {
        const salary = await Salary.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
              message: "Data tidak ditemukan",
            });

        return res.json(salary);
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
const putid = async (req, res) => {
    const { id } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const salary = await Salary.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
              message: "Data tidak ditemukan",

            });
        
            await salary.update(updateData);
            return res.status(201).json({
                message: 'Updated'
            });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const { id } = req.params;

    try {
        const salary = await Salary.findByPk(id, {});
        if (!salary)
            return res.status(404).json({
              message: "Data tidak ditemukan",
            });
        
            await salary.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}