const { Pinjam, Karyawan, Sequelize } = require("../models");
const Op = Sequelize.Op;

const postcreate = async (req, res) => {
    const { body } = req;
    const createdBy = req.user.data.username;
    let createData = { ...req.body, createdBy };

    if (!body.nip){
        return res.status(400).json({
            "Validation Error": {
                field:"nip",
                message:"Tidak Boleh Null/Kosong"}
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }else{
        
        try {
            await Pinjam.create(createData);
    
            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
                console.log(error)
            }
        }
    } 
     
}
const getall = async (req, res) => {
    const {
        body
    } = req;

    let nnip = '%%'
    if (body.nip) {
        nnip = body.nip
    }
    try {
        const Pinjams = await Pinjam.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] },
            where: {
                nip: {
                    [Op.like]: nnip,
                }
            }
        });
        if (Pinjams.length != 0) {
            return res.json(Pinjams);
        } else {
            res.status(404).json({
                message: "Data tidak ditemukan",
            })            
        }

    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
        console.log(error)
    }
    
}
const getid = async (req, res) => {
    const { id } = req.params;

    try {
        const pinjam = await Pinjam.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!pinjam)
            return res.status(404).json({
              message: "Data tidak ditemukan",
            });

        return res.json(pinjam);
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
const putid = async (req, res) => {
    const { id } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const pinjam = await Pinjam.findByPk(id, {});
        if (!pinjam)
            return res.status(404).json({
              message: "Data tidak ditemukan",

            });
        
            await pinjam.update(updateData);
            return res.status(201).json({
                message: 'Updated'
            });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const { id } = req.params;

    try {
        const pinjam = await Pinjam.findByPk(id, {});
        if (!pinjam)
            return res.status(404).json({
              message: "Data tidak ditemukan",
            });
        
            await pinjam.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}