const {
    Karyawanfm
} = require("../models");
const {
    Karyawan
} = require("../models");

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdby = req.user.data.username;
    if (!body.nip)
        return res.status(400).json({
            "Validation Error": {
                field:"nip",
                message:"Tidak Boleh Null/Kosong"}
        });
    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    } else {
        try {
            await Karyawanfm.create({
                nik: body.nik,
                nmlengkap: body.nmlengkap,
                hubungan: body.hubungan,
                nohp: body.nohp,
                nip: body.nip,
                createdBy: createdby
            });

            return res.status(201).json({
                message: 'Created'
                // data: {
                //     karyawanfm
                // }
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
            }
        }
    }
}

const getall = async (req, res) => {
    const {
        body
    } = req;
    if (!body.nip)
        return res.status(400).json({
            message: "nip required",
        });
    try {
        const karyawansfm = await Karyawanfm.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] },
            where: {
                nip: body.nip
            }
        });
        if (karyawansfm.length != 0) {
            return res.json(karyawansfm);
        } else {
            res.status(404).json({
                message: "Data tidak ditemukan",
            })            
        }

    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const karyawanfm = await Karyawanfm.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!karyawanfm)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(karyawanfm);
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const karyawansfm = await Karyawanfm.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!karyawansfm)
            return res.status(404).json({
                message: "Data tidak ditemukan",
            });

        await karyawansfm.update(req.body);
        return res.json({
            message: "Updated",
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const karyawansfm = await Karyawanfm.findByPk(id, {});
        if (!karyawansfm)
            return res.status(404).json({
                message: "data keluarga karyawan tidak ditemukan",

            });

        await karyawansfm.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({error: 'Internal Server Error'})
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}