const {
    Jenistr
} = require("../models");

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdby = req.user.data.username;

    const cekJenis = await Jenistr.findOne({
        where: {
            namatr: body.namatr,
        },
    });
    if (cekJenis) {
        return res.status(400).json({
            message: "Nama Jenis Transaksi sudah ada",
        });
    } else {
        try {
            await Jenistr.create({
                namatr: body.namatr,
                typetr: body.typetr,
                createdBy:createdby
            });
        
            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
            }
        }
    }
}
const getall = async (req, res) => {
    try {
        const jenistrs = await Jenistr.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if(jenistrs.length != 0){ 
            return res.json(jenistrs);
        } else { 
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }        
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const jenistrs = await Jenistr.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!jenistrs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(jenistrs);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const jenistrs = await Jenistr.findByPk(id, {});
        if (!jenistrs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await jenistrs.update(updateData);
        return res.status(201).json({
            message: 'Updated'            
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const jenistrs = await Jenistr.findByPk(id, {});
        if (!jenistrs)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await jenistrs.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}