const {
    Bank
} = require("../models");

const testaja = async (req, res) => {
    const {
        body
    } = req;
    console.log(body);
    return res.status(201).json({
        message: "Ok"
    })
}

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdby = req.user.data.username;

    const cekNamaBank = await Bank.findOne({
        where: {
            nm_bank: body.nm_bank,
        },
    });
    if (cekNamaBank) {
        return res.status(400).json({
            message: "Nama Bank sudah ada",
        });
    } else {
        try {
            await Bank.create({
                nm_bank: body.nm_bank,
                createdBy:createdby
            });
        
            return res.status(201).json({
                message: 'Created'
                // data: {
                //     id: bank.id,
                //     nmbank: body.nm_bank
                // }
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
            }
        }
    }
}
// Get All Data Bank
const getall = async (req, res) => {
    try {
        const banks = await Bank.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if(banks.length != 0){ 
            return res.json(banks);
        } else { 
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }        
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const bank = await Bank.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!bank)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(bank);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const bank = await Bank.findByPk(id, {});
        if (!bank)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await bank.update(updateData);
        return res.status(201).json({
            message: 'Updated'            
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const bank = await Bank.findByPk(id, {});
        if (!bank)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await bank.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
module.exports = {
    testaja,
    getall,
    postcreate,
    getid,
    putid,
    delid
}