const {
    Ajudana, Karyawan
} = require("../models");

const postcreate = async (req, res) => {
    const {
        body
    } = req;
    const createdBy = req.user.data.username;
    let createData = { ...req.body, createdBy };
    if (!body.nip){
        return res.status(400).json({
            "Validation Error": {
                field:"nip",
                message:"Tidak Boleh Null/Kosong"}
        });
    }

    const cekNIP = await Karyawan.findOne({
        where: {
            nip: body.nip,
        },
    });

    if (!cekNIP) {
        return res.status(404).json({
            message: "Data Karyawan tidak ditemukan"
        });
    }else{
        try {
            await Ajudana.create(createData);
        
            return res.status(201).json({
                message: 'Created'
            });
        } catch (error) {
            if (error.name === 'SequelizeValidationError') {
                const validationErrors = error.errors.map(err => ({
                    field: err.path,
                    message: err.message
                }));
                res.status(400).json({
                    "Validation Error": validationErrors
                });
            } else {
                res.status(500).json({
                    error: 'Internal Server Error'
                });
            }
        }
    }    
}
const getall = async (req, res) => {
    try {
        const Ajudanas = await Ajudana.findAll({
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if(Ajudanas.length != 0){ 
            return res.json(Ajudanas);
        } else { 
            return res.status(404).json({
                message: "Data tidak ditemukan"
            });
        }        
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const getid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Ajudanas = await Ajudana.findByPk(id, {
            attributes: { exclude: ['createdBy', 'updatedBy', 'createdAt', 'updatedAt'] }
        });
        if (!Ajudanas)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        return res.json(Ajudanas);
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
const putid = async (req, res) => {
    const {
        id
    } = req.params;
    const updatedBy = req.user.data.username;
    let updateData = { ...req.body, updatedBy };
    try {
        const Ajudanas = await Ajudana.findByPk(id, {});
        if (!Ajudanas)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Ajudanas.update(updateData);
        return res.status(201).json({
            message: 'Updated'            
        });
    } catch (error) {
        if (error.name === 'SequelizeValidationError') {
            const validationErrors = error.errors.map(err => ({
                field: err.path,
                message: err.message
            }));
            res.status(400).json({
                "Validation Error": validationErrors
            });
        } else {
            res.status(500).json({
                error: 'Internal Server Error'
            });
        }
    }
}
const delid = async (req, res) => {
    const {
        id
    } = req.params;

    try {
        const Ajudanas = await Ajudana.findByPk(id, {});
        if (!Ajudanas)
            return res.status(404).json({
                message: "Data tidak ditemukan",

            });

        await Ajudanas.destroy();
        return res.json({
            message: "Deleted",
        });
    } catch (error) {
        res.status(500).json({
            error: 'Internal Server Error'
        });
    }
}
module.exports = {
    getall,
    postcreate,
    getid,
    putid,
    delid
}